<?php
class VCurl
{
    private $_verbose = false;
    private $_progress = true;
    function __construct()
    {
	if ( defined('_CONSOLE') ) {
	    $this->_verbose 	= true;
	    $this->_progress 	= false;
	}
    }
    
    function VCurl()
    {
        $this->__construct();
    }

    function saveToString( $url, $cookie=NULL )
    {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HEADER, false);
        curl_setopt($ch, CURLOPT_VERBOSE, $this->_verbose);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
        curl_setopt($ch, CURLOPT_NOPROGRESS, $this->_progress);
        curl_setopt($ch, CURLOPT_USERAGENT, '"Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.11) Gecko/20071204 Ubuntu/7.10 (gutsy) Firefox/2.0.0.11');
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        if ( $cookie ) {
            curl_setopt($ch, CURLOPT_COOKIE, $cookie);
        }

        $string = curl_exec($ch);        
        if ( curl_errno($ch) ) {
            return false;
        }
        
        curl_close($ch);
        
        return $string;
    }
    
    function saveToFile( $url, $local, $cookie=NULL )
    {
        $ch = curl_init();
        $fh = fopen($local, 'w');
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_FILE, $fh);
        curl_setopt($ch, CURLOPT_HEADER, false);
        curl_setopt($ch, CURLOPT_VERBOSE, $this->_verbose);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
        curl_setopt($ch, CURLOPT_NOPROGRESS, $this->_progress);
        curl_setopt($ch, CURLOPT_USERAGENT, '"Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.11) Gecko/20071204 Ubuntu/7.10 (gutsy) Firefox/2.0.0.11');
        if ( $cookie ) {
            curl_setopt($ch, CURLOPT_COOKIE, $cookie);
        }
        curl_exec($ch);
        
        if( curl_errno($ch) ) {
            return false;
        }
        
        curl_close($ch);
        fclose($fh);
        
        if( filesize($local) > 10 ) {
            return true;
        }
        
        return false;
    }
    
    function getRemoteSize( $url, $cookie=NULL )
    {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_HEADER, 1);
        curl_setopt($ch, CURLOPT_NOBODY, 1);
        curl_setopt($ch, CURLOPT_VERBOSE, false);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
        curl_setopt($ch, CURLOPT_USERAGENT, '"Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.8.1.11) Gecko/20071204 Ubuntu/7.10 (gutsy) Firefox/2.0.0.11');
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        if ( $cookie ) {
            curl_setopt($ch, CURLOPT_COOKIE, $cookie);
        }
        
        $head   = curl_exec($ch);
        if ( curl_errno($ch) ) {
            return false;
        }
        
        curl_close($ch);
        
        $regex = '/Content-Length:\s([0-9].+?)\s/';
        $count = preg_match($regex, $head, $matches);
        
        return isset($matches['1']) ? $this->bytes($matches['1']) : 'unknown';
    }
    
    function bytes($a) {
        $unim = array("B","KB","MB","GB","TB","PB");
        $c = 0;
        while ( $a >= 1024 ) {
            $c++;
            $a = $a/1024;
        }
        
        return number_format($a,($c ? 2 : 0),",",".")." ".$unim[$c];
    }
}
?>